
import gurobipy as gp

# Create a new model
m = gp.Model("work_optimization")

# Create variables
bill = m.addVar(vtype=gp.GRB.INTEGER, name="bill")
mary = m.addVar(vtype=gp.GRB.CONTINUOUS, name="mary")
jean = m.addVar(vtype=gp.GRB.CONTINUOUS, name="jean")
bobby = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby")
peggy = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy")
john = m.addVar(vtype=gp.GRB.CONTINUOUS, name="john")
laura = m.addVar(vtype=gp.GRB.CONTINUOUS, name="laura")

# Set objective function
m.setObjective(9.14 * bill + 5.59 * mary + 5.6 * jean + 5.74 * bobby + 7.63 * peggy + 4.24 * john + 8.77 * laura, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * bobby + 2 * peggy >= 12)
m.addConstr(4 * jean + 4 * john >= 17)
m.addConstr(6 * bill + 4 * john >= 7)
m.addConstr(7 * mary + 4 * jean >= 15)
m.addConstr(6 * bill + 4 * jean >= 11)
m.addConstr(4 * jean + 2 * peggy >= 16)
m.addConstr(7 * mary + 13 * bobby >= 12)
m.addConstr(4 * jean + 13 * bobby >= 11)
m.addConstr(2 * peggy + 9 * laura >= 5)
m.addConstr(7 * mary + 9 * laura >= 6)

# ... (Add remaining constraints from JSON "constraints" field)

m.addConstr(4 * jean + 9 * laura <= 25)
m.addConstr(4 * jean + 4 * john <= 43)
m.addConstr(13 * bobby + 2 * peggy <= 95)
m.addConstr(6 * bill + 2 * peggy <= 23)
m.addConstr(6 * bill + 4 * john <= 107)
m.addConstr(6 * bill + 4 * jean <= 44)
m.addConstr(2 * peggy + 4 * john <= 30)
m.addConstr(7 * mary + 13 * bobby <= 70)
m.addConstr(6 * bill + 13 * bobby <= 54)
m.addConstr(4 * jean + 13 * bobby <= 33)
m.addConstr(13 * bobby + 9 * laura <= 79)
m.addConstr(4 * jean + 2 * peggy <= 20)
m.addConstr(7 * mary + 9 * laura <= 108)
m.addConstr(2 * peggy + 9 * laura <= 105)
m.addConstr(7 * mary + 2 * peggy <= 95)
m.addConstr(7 * mary + 4 * jean <= 41)
m.addConstr(6 * bill + 4 * john + 9 * laura <= 117)
m.addConstr(6 * bill + 7 * mary + 4 * jean + 13 * bobby + 2 * peggy + 4 * john + 9 * laura <= 124)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)
