
import gurobi as gp

# Define variables
xB = gp.Var(name="hours worked by Bill", lb=0)
xM = gp.Var(name="hours worked by Mary", lb=0)
xJ = gp.Var(name="hours worked by Jean", lb=0)
xBo = gp.Var(name="hours worked by Bobby", lb=0)
xP = gp.Var(name="hours worked by Peggy", lb=0)
xJo = gp.Var(name="hours worked by John", lb=0)
xL = gp.Var(name="hours worked by Laura", lb=0)

# Create model
m = gp.Model()

# Objective function
m.setObjective(9.14*xB + 5.59*xM + 5.6*xJ + 5.74*xBo + 7.63*xP + 4.24*xJo + 8.77*xL, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(6*xB <= 124)
m.addConstr(7*xM <= 124)
m.addConstr(4*xJ <= 124)
m.addConstr(13*xBo <= 124)
m.addConstr(2*xP <= 124)
m.addConstr(4*xJo <= 124)
m.addConstr(9*xL <= 124)
m.addConstr(13*xBo + 2*xP >= 12)
m.addConstr(4*xJ + 4*xJo >= 17)
m.addConstr(6*xB + 4*xJo >= 7)
m.addConstr(7*xM + 4*xJ >= 15)
m.addConstr(6*xB + 4*xJ >= 11)
m.addConstr(13*xBo + 2*xP >= 12)
m.addConstr(7*xM + 13*xBo >= 12)
m.addConstr(4*xJ + 13*xBo >= 11)
m.addConstr(2*xP + 9*xL >= 5)
m.addConstr(7*xM + 9*xL >= 6)
m.addConstr(4*xJ + 4*xJo + 9*xL >= 11)
m.addConstr(4*xJ + 2*xP + 4*xJo >= 11)
m.addConstr(6*xB + 13*xBo + 2*xP >= 11)
m.addConstr(6*xB + 13*xBo + 9*xL >= 11)
m.addConstr(7*xM + 13*xBo + 9*xL >= 11)
m.addConstr(13*xBo + 2*xP + 9*xL >= 11)
m.addConstr(6*xB + 4*xJo + 9*xL >= 11)
m.addConstr(13*xBo + 4*xJo + 9*xL >= 11)
m.addConstr(7*xM + 4*xJ + 4*xJo >= 17)
m.addConstr(6*xB + 4*xJ + 4*xJo >= 17)
m.addConstr(6*xB + 4*xJ + 2*xP >= 17)
m.addConstr(7*xM + 4*xJ + 2*xP >= 17)
m.addConstr(7*xM + 2*xP + 9*xL >= 17)
m.addConstr(6*xB + 13*xBo + 4*xJo >= 17)
m.addConstr(6*xB + 4*xJ + 9*xL >= 17)
m.addConstr(7*xM + 13*xBo + 9*xL >= 17)
m.addConstr(13*xBo + 2*xP + 9*xL >= 17)
m.addConstr(6*xB + 4*xJo + 9*xL >= 17)
m.addConstr(13*xBo + 4*xJo + 9*xL >= 17)

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", xB.varValue)
    print("Hours worked by Mary: ", xM.varValue)
    print("Hours worked by Jean: ", xJ.varValue)
    print("Hours worked by Bobby: ", xBo.varValue)
    print("Hours worked by Peggy: ", xP.varValue)
    print("Hours worked by John: ", xJo.varValue)
    print("Hours worked by Laura: ", xL.varValue)
else:
    print("No solution found")
