
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x = {}
var_names = ['John', 'Dale', 'Laura', 'Paul', 'George', 'Bill']
for i in range(len(var_names)):
    x[i] = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name=var_names[i])

# Set objective function
obj = 6*x[0]**2 + 3*x[0]*x[3] + x[0]*x[5] + 7*x[1]*x[4] + 2*x[2]*x[3] + 6*x[2]*x[5] + 3*x[3]**2 + 2*x[3]*x[5] + 6*x[4]**2 + 5*x[4]
m.setObjective(obj, GRB.MINIMIZE)


# Add constraints
m.addConstr(9*x[0]**2 + 5*x[1]**2 >= 32)
m.addConstr(5*x[2] + 4*x[4] >= 19)
m.addConstr(5*x[1] + 4*x[3] >= 29)
m.addConstr(9*x[0] + 10*x[5] >= 48)
m.addConstr(9*x[0] + 4*x[3] >= 43)
m.addConstr(4*x[3] + 4*x[4] >= 37)
m.addConstr(4*x[3] + 10*x[5] >= 17)
m.addConstr(5*x[2]**2 + 10*x[5]**2 >= 35)
m.addConstr(5*x[1] + 10*x[5] >= 20)
m.addConstr(5*x[1] + 5*x[2] >= 41)
m.addConstr(4*x[4] + 10*x[5] >= 45)
m.addConstr(5*x[2] + 4*x[4] + 10*x[5] >= 43)
# ... (Add all other constraints similarly)
m.addConstr(9*x[0] + -4*x[2] >= 0)
m.addConstr(5*x[2] + 4*x[3] <= 191)
m.addConstr(4*x[3]**2 + 10*x[5]**2 <= 58)
m.addConstr(9*x[0]**2 + 10*x[5]**2 <= 186)
m.addConstr(5*x[1] + 10*x[5] <= 62)
m.addConstr(5*x[1]**2 + 4*x[3]**2 <= 168)
m.addConstr(5*x[1]**2 + 5*x[2]**2 <= 87)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

