
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x = m.addVars(6, name="x", lb=0)  # Assuming lb=0 for non-negativity

# Objective function
m.setObjective(6*x[0]**2 + 3*x[0]*x[3] + x[0]*x[5] + 7*x[1]*x[4] + 2*x[2]*x[3] + 6*x[2]*x[5] + 
               3*x[3]**2 + 2*x[3]*x[5] + 6*x[4]**2 + 5*x[4], gp.GRB.MINIMIZE)

# Constraints
# Attributes for each resource
r0 = {0: 9, 1: 5, 2: 5, 3: 4, 4: 4, 5: 10}
r1 = {0: 6, 1: 3, 2: 8, 3: 6, 4: 6, 5: 7}
r2 = {0: 7, 1: 6, 2: 6, 3: 8, 4: 3, 5: 11}
r3 = {0: 8, 1: 11, 2: 4, 3: 7, 4: 11, 5: 4}

# Individual constraints
for i in range(6):
    m.addConstr(r0[i]*x[i] <= 302, name=f"r0_{i}")
    m.addConstr(r1[i]*x[i] <= 294, name=f"r1_{i}")
    m.addConstr(r2[i]*x[i] <= 173, name=f"r2_{i}")
    m.addConstr(r3[i]*x[i] <= 387, name=f"r3_{i}")

# Additional constraints
m.addConstr(x[0]**2 + x[1]**2 >= 32)
m.addConstr(x[2] + x[4] >= 19)
m.addConstr(x[1] + x[3] >= 29)
m.addConstr(x[0] + x[5] >= 48)
m.addConstr(x[0] + x[3] >= 43)
m.addConstr(x[3] + x[4] >= 37)
m.addConstr(x[3] + x[5] >= 17)
m.addConstr(x[2]**2 + x[5]**2 >= 35)
m.addConstr(x[1] + x[5] >= 20)
m.addConstr(x[1] + x[2] >= 41)
m.addConstr(x[4] + x[5] >= 45)
m.addConstr(x[2] + x[4] + x[5] >= 43)
m.addConstr(x[0]**2 + x[1]**2 + x[5]**2 >= 43)
m.addConstr(x[1] + x[2] + x[3] >= 43)
m.addConstr(x[1] + x[3] + x[4] >= 43)
m.addConstr(x[0] + x[2] + x[4] >= 43)
m.addConstr(x[2] + x[3] + x[5] >= 43)
m.addConstr(x[0] + x[1] + x[4] >= 43)
m.addConstr(x[0]**2 + x[3]**2 + x[5]**2 >= 43)
m.addConstr(x[3]**2 + x[4]**2 + x[5]**2 >= 43)
m.addConstr(x[2] + x[3] + x[4] >= 43)
m.addConstr(x[0] + x[1] + x[3] >= 43)
m.addConstr(x[1] + x[3] + x[4] >= 43)
m.addConstr(x[0] + x[4] + x[5] >= 43)
m.addConstr(x[1] + x[2] + x[5] >= 43)
m.addConstr(x[2] + x[4] + x[5] >= 27)
m.addConstr(x[0] + x[1] + x[5] >= 27)
m.addConstr(x[1]**2 + x[2]**2 + x[3]**2 >= 27)
m.addConstr(x[1]**2 + x[3]**2 + x[4]**2 >= 27)
m.addConstr(x[0]**2 + x[2]**2 + x[4]**2 >= 27)
m.addConstr(x[2] + x[3] + x[5] >= 27)
m.addConstr(x[0] + x[1] + x[4] >= 27)
m.addConstr(x[0] + x[3] + x[5] >= 27)
m.addConstr(x[3] + x[4] + x[5] >= 27)
m.addConstr(x[1] + x[2] + x[5] >= 27)
m.addConstr(x[2]**2 + x[4]**2 + x[5]**2 >= 49)
m.addConstr(x[0]**2 + x[1]**2 + x[5]**2 >= 49)
m.addConstr(x[1] + x[2] + x[3] >= 49)
m.addConstr(x[1] + x[3] + x[4] >= 49)
m.addConstr(x[0]**2 + x[2]**2 + x[4]**2 >= 49)
m.addConstr(x[2] + x[3] + x[5] >= 49)
m.addConstr(x[0] + x[1] + x[4] >= 49)
m.addConstr(x[0] + x[3] + x[5] >= 49)
m.addConstr(x[3] + x[4] + x[5] >= 49)
m.addConstr(x[2] + x[3] + x[4] >= 49)
m.addConstr(x[0] + x[1] + x[3] >= 49)
m.addConstr(x[1] + x[4] + x[5] >= 49)
m.addConstr(x[0] + x[4] + x[5] >= 49)
m.addConstr(x[1] + x[2] + x[5] >= 49)
m.addConstr(x[2]**2 + x[4]**2 + x[5]**2 >= 44)
m.addConstr(x[0] + x[1] + x[5] >= 44)
m.addConstr(x[1] + x[2] + x[3] >= 44)
m.addConstr(x[1]**2 + x[3]**2 + x[4]**2 >= 44)
m.addConstr(x[0] + x[2] + x[4] >= 44)
m.addConstr(x[2] + x[3] + x[5] >= 44)
m.addConstr(x[0] + x[1] + x[4] >= 44)
m.addConstr(x[0] + x[3] + x[5] >= 44)
m.addConstr(x[3]**2 + x[4]**2 + x[5]**2 >= 44)
m.addConstr(x[2]**2 + x[3]**2 + x[4]**2 >= 44)
m.addConstr(x[0] + x[1] + x[3] >= 44)
m.addConstr(x[1] + x[4] + x[5] >= 44)
m.addConstr(x[0] + x[4] + x[5] >= 44)
m.addConstr(x[1] + x[2] + x[5] >= 44)
m.addConstr(x[2] + x[4] + x[5] >= 28)
m.addConstr(x[0] + x[3] + x[5] >= 28)
m.addConstr(x[1] + x[3] + x[4] >= 28)
m.addConstr(x[0] + x[2] + x[4] >= 28)
m.addConstr(x[2]**2 + x[3]**2 + x[5]**2 >= 28)
m.addConstr(9*x[0] + -4*x[2] >= 0)
m.addConstr(5*x[2]**2 + -1*x[4]**2 + -8*x[5]**2 >= 0)
m.addConstr(10*x[2] + 8*x[3] <= 191)
m.addConstr(x[3]**2 + x[5]**2 <= 58)
m.addConstr(x[0]**2 + x[5]**2 <= 186)
m.addConstr(x[1] + 10*x[5] <= 62)
m.addConstr(x[1]**2 + x[3]**2 <= 168)
m.addConstr(x[1]**2 + x[2]**2 <= 87)
m.addConstr(x[1] + x[4] + 10*x[5] <= 281)
m.addConstr(x[1] + x[2] + x[3] <= 293)
m.addConstr(x[0]**2 + x[2]**2 + x[5]**2 <= 85)
m.addConstr(x[0] + x[1] + x[2] <= 297)
m.addConstr(x[2] + x[3] + x[5] <= 291)
m.addConstr(x[1] + x[3] + x[4] <= 254)
m.addConstr(x[3]**2 + x[4]**2 + x[5]**2 <= 208)
m.addConstr(x[2]**2 + x[4]**2 <= 49)
m.addConstr(x[0] + x[4] <= 193)
m.addConstr(x[0] + x[2] <= 222)
m.addConstr(x[1]**2 + x[4]**2 <= 137)
m.addConstr(x[0] + x[5] <= 207)
m.addConstr(x[2]**2 + x[3]**2 <= 73)
m.addConstr(x[1] + x[5] <= 238)
m.addConstr(x[1] + x[2] <= 172)
m.addConstr(x[0] + x[1] <= 193)
m.addConstr(x[0] + x[3] <= 294)
m.addConstr(x[1] + x[2] + x[4] <= 97)
m.addConstr(x[2]**2 + x[4]**2 + x[5]**2 <= 290)
m.addConstr(x[0] + x[4] + x[5] <= 53)
m.addConstr(x[0] + x[1] + x[2] <= 195)
m.addConstr(x[1] + x[3] + x[4] <= 88)
m.addConstr(x[0] + x[3] + x[4] <= 173)
m.addConstr(x[0] + x[1] + x[5] <= 120)
m.addConstr(x[0] + x[2] + x[5] <= 214)
m.addConstr(x[0]**2 + x[1]**2 + x[3]**2 <= 96)
m.addConstr(x[3] + x[4] + x[5] <= 155)
m.addConstr(x[1] + x[2] + x[5] <= 179)
m.addConstr(x[1]**2 + x[3]**2 + x[5]**2 <= 263)
m.addConstr(x[2] + x[4] <= 101)
m.addConstr(x[0] + x[5] <= 49)
m.addConstr(x[1] + x[5] <= 127)
m.addConstr(x[0]**2 + x[2]**2 <= 64)
m.addConstr(x[2]**2 + x[3]**2 <= 152)
m.addConstr(x[0]**2 + x[3]**2 <= 65)
m.addConstr(x[0] + x[4] <= 104)
m.addConstr(x[3]**2 + x[4]**2 <= 123)
m.addConstr(x[0]**2 + x[1]**2 + x[5]**2 <= 209)
m.addConstr(x[0] + x[2] + x[5] <= 341)
m.addConstr(x[2] + x[3] + x[4] <= 296)
m.addConstr(x[3] + x[4] + x[5] <= 82)
m.addConstr(x[0]**2 + x[1]**2 + x[4]**2 <= 361)
m.addConstr(x[0] + x[3] + x[5] <= 144)
m.addConstr(x[0] + x[2] + x[3] <= 153)
m.addConstr(x[1] + x[2] + x[3] <= 226)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    for i in range(6):
        print(f"x[{i}] = {x[i].varValue}")
else:
    print("No optimal solution found.")
