
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, names=["rotisserie_chickens", "cornichons", "ravioli", "pickles"])

# Set objective function
m.setObjective(8*x[0] + 3*x[1] + 1*x[2] + 9*x[3], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x[0] + 3*x[3] >= 35)
m.addConstr(8*x[0] + 17*x[2] >= 35)
m.addConstr(12*x[1] + 17*x[2] >= 28)
m.addConstr(12*x[1] + 3*x[3] >= 18)
m.addConstr(8*x[0] + 12*x[1] + 17*x[2] + 3*x[3] >= 18)
m.addConstr(17*x[2] + 12*x[3] >= 40)
m.addConstr(5*x[0] + 17*x[2] >= 44)
m.addConstr(5*x[0] + 17*x[2] + 12*x[3] >= 52)
m.addConstr(5*x[0] + 3*x[1] + 12*x[3] >= 52)
m.addConstr(3*x[1] + 17*x[2] + 12*x[3] >= 52)
m.addConstr(5*x[0] + 17*x[2] + 12*x[3] >= 51)
m.addConstr(5*x[0] + 3*x[1] + 12*x[3] >= 51)
m.addConstr(3*x[1] + 17*x[2] + 12*x[3] >= 51)
m.addConstr(5*x[0] + 17*x[2] + 12*x[3] >= 49)
m.addConstr(5*x[0] + 3*x[1] + 12*x[3] >= 49)
m.addConstr(3*x[1] + 17*x[2] + 12*x[3] >= 49)
m.addConstr(5*x[0] + 3*x[1] + 17*x[2] + 12*x[3] >= 49)
m.addConstr(10*x[1] - 8*x[2] >= 0)
m.addConstr(1*x[1] - 3*x[3] >= 0)
m.addConstr(-8*x[0] + 9*x[2] >= 0)
m.addConstr(8*x[0] + 12*x[1] + 3*x[3] <= 99)
m.addConstr(8*x[0] + 17*x[2] + 3*x[3] <= 130)
m.addConstr(12*x[1] + 17*x[2] + 3*x[3] <= 52)
m.addConstr(5*x[0] + 3*x[1] + 12*x[3] <= 176)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Obj: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

