
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="squash_plants")
    x1 = m.addVar(vtype=GRB.INTEGER, name="chives")
    x2 = m.addVar(vtype=GRB.INTEGER, name="orange_trees")


    # Set objective function
    m.setObjective(7*x0**2 + 9*x0*x1 + 2*x2**2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(23*x0 + 16*x1 >= 129, "c0")
    m.addConstr(23**2*x0**2 + 13**2*x2**2 >= 84, "c1")
    m.addConstr(23*x0 + 16*x1 + 13*x2 >= 84, "c2")
    m.addConstr(9*x1 - 3*x2 >= 0, "c3")
    m.addConstr(5*x0 - 7*x2 >= 0, "c4")
    m.addConstr(23*x0 + 16*x1 <= 314, "c5")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('squash_plants:', x0.x)
        print('chives:', x1.x)
        print('orange_trees:', x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
