
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='squash_plants', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='chives', vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name='orange_trees', vtype=gurobi.GRB.INTEGER)

# Set the objective function
model.setObjective(7*x1**2 + 9*x1*x2 + 2*x3**2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(23*x1 + 16*x2 >= 129)
model.addConstr(23**2*x1**2 + 13**2*x3**2 >= 84)
model.addConstr(23*x1 + 16*x2 + 13*x3 >= 84)
model.addConstr(9*x2 - 3*x3 >= 0)
model.addConstr(5*x1 - 7*x3 >= 0)
model.addConstr(23*x1 + 16*x2 <= 314)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('squash plants: ', x1.varValue)
    print('chives: ', x2.varValue)
    print('orange trees: ', x3.varValue)
else:
    print('The model is infeasible')
