
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, names=["George", "Dale", "Ringo", "Laura", "Paul", "Hank"])

# Set objective function
m.setObjective(5*x[0] + 9*x[1] + 7*x[2] + 8*x[3] + 5*x[4] + 6*x[5], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x[2] + 23*x[4] >= 23)
m.addConstr(20*x[1] + 10*x[3] >= 37)
m.addConstr(10*x[3] + 22*x[5] >= 51)
m.addConstr(2*x[0] + 20*x[1] >= 33)
m.addConstr(20*x[1] + 23*x[4] + 22*x[5] >= 35)
m.addConstr(2*x[0] + 20*x[1] + 22*x[5] >= 35)
m.addConstr(2*x[0] + 20*x[1] + 10*x[3] >= 35)
m.addConstr(20*x[1] + 23*x[4] + 22*x[5] >= 30)
m.addConstr(2*x[0] + 20*x[1] + 22*x[5] >= 30)
m.addConstr(2*x[0] + 20*x[1] + 10*x[3] >= 30)
m.addConstr(20*x[1] + 23*x[4] + 22*x[5] >= 48)
m.addConstr(2*x[0] + 20*x[1] + 22*x[5] >= 48)
m.addConstr(2*x[0] + 20*x[1] + 10*x[3] >= 48)
m.addConstr(2*x[0] + 20*x[1] + 11*x[2] + 10*x[3] + 23*x[4] + 22*x[5] >= 48)
m.addConstr(6*x[1] + 18*x[2] >= 28)
m.addConstr(9*x[3] + 25*x[4] >= 22)
m.addConstr(6*x[1] + 25*x[4] >= 25)
m.addConstr(6*x[1] + 9*x[3] >= 21)
m.addConstr(25*x[4] + 8*x[5] >= 17)
m.addConstr(25*x[0] + 6*x[1] + 18*x[2] + 9*x[3] + 25*x[4] + 8*x[5] >= 17)
m.addConstr(10*x[0] - 10*x[1] >= 0)
m.addConstr(10*x[3] + 23*x[4] <= 118)
m.addConstr(10*x[3] + 22*x[5] <= 74)
m.addConstr(20*x[1] + 22*x[5] <= 147)
m.addConstr(2*x[0] + 10*x[3] + 23*x[4] <= 131)
m.addConstr(2*x[0] + 11*x[2] + 10*x[3] <= 146)
m.addConstr(2*x[0] + 10*x[3] + 22*x[5] <= 215)
m.addConstr(2*x[0] + 20*x[1] + 22*x[5] <= 252)
m.addConstr(9*x[3] + 25*x[4] <= 42)
m.addConstr(25*x[0] + 6*x[1] <= 140)
m.addConstr(6*x[1] + 9*x[3] + 25*x[4] <= 64)
m.addConstr(9*x[3] + 25*x[4] + 8*x[5] <= 68)
m.addConstr(25*x[0] + 9*x[3] + 25*x[4] <= 155)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
