
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x4")
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x5")

    # Define the objective function
    model.setObjective(5*x0 + 9*x1 + 7*x2 + 8*x3 + 5*x4 + 6*x5, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x0 <= 306)
    model.addConstr(25*x0 <= 175)
    model.addConstr(20*x1 <= 306)
    model.addConstr(6*x1 <= 175)
    model.addConstr(11*x2 <= 306)
    model.addConstr(18*x2 <= 175)
    model.addConstr(10*x3 <= 306)
    model.addConstr(9*x3 <= 175)
    model.addConstr(23*x4 <= 306)
    model.addConstr(25*x4 <= 175)
    model.addConstr(22*x5 <= 306)
    model.addConstr(8*x5 <= 175)
    model.addConstr(11*x2 + 23*x4 >= 23)
    model.addConstr(20*x1 + 10*x3 >= 37)
    model.addConstr(10*x3 + 22*x5 >= 51)
    model.addConstr(2*x0 + 20*x1 >= 33)
    model.addConstr(20*x1 + 23*x4 + 22*x5 >= 35)
    model.addConstr(2*x0 + 20*x1 + 22*x5 >= 35)
    model.addConstr(2*x0 + 20*x1 + 10*x3 >= 35)
    model.addConstr(20*x1 + 23*x4 + 22*x5 >= 30)
    model.addConstr(2*x0 + 20*x1 + 22*x5 >= 30)
    model.addConstr(2*x0 + 20*x1 + 10*x3 >= 30)
    model.addConstr(20*x1 + 23*x4 + 22*x5 >= 48)
    model.addConstr(2*x0 + 20*x1 + 22*x5 >= 48)
    model.addConstr(2*x0 + 20*x1 + 10*x3 >= 48)
    model.addConstr(2*x0 + 20*x1 + 7*x2 + 10*x3 + 23*x4 + 22*x5 >= 48)
    model.addConstr(6*x1 + 18*x2 >= 28)
    model.addConstr(9*x3 + 25*x4 >= 22)
    model.addConstr(6*x1 + 25*x4 >= 25)
    model.addConstr(6*x1 + 9*x3 >= 21)
    model.addConstr(25*x4 + 8*x5 >= 17)
    model.addConstr(25*x0 + 6*x1 + 18*x2 + 9*x3 + 25*x4 + 8*x5 >= 17)
    model.addConstr(10*x0 - 10*x1 >= 0)
    model.addConstr(10*x3 + 23*x4 <= 118)
    model.addConstr(10*x3 + 22*x5 <= 74)
    model.addConstr(20*x1 + 22*x5 <= 147)
    model.addConstr(2*x0 + 10*x3 + 23*x4 <= 131)
    model.addConstr(2*x0 + 11*x2 + 10*x3 <= 146)
    model.addConstr(2*x0 + 10*x3 + 22*x5 <= 215)
    model.addConstr(2*x0 + 20*x1 + 22*x5 <= 252)
    model.addConstr(9*x3 + 25*x4 <= 42)
    model.addConstr(25*x0 + 6*x1 <= 140)
    model.addConstr(6*x1 + 9*x3 + 25*x4 <= 64)
    model.addConstr(9*x3 + 25*x4 + 8*x5 <= 68)
    model.addConstr(25*x0 + 9*x3 + 25*x4 <= 155)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
