
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B9")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B5")


    # Set objective function
    m.setObjective(1.18 * x0 + 8.37 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7 * x0 + 5 * x1 >= 31, "c0")
    m.addConstr(14 * x0 + 13 * x1 >= 21, "c1")
    m.addConstr(4 * x0 + 6 * x1 >= 42, "c2")
    m.addConstr(-7 * x0 + 8 * x1 >= 0, "c3")
    m.addConstr(7 * x0 + 5 * x1 <= 101, "c4")
    m.addConstr(14 * x0 + 13 * x1 <= 61, "c5")
    m.addConstr(4 * x0 + 6 * x1 <= 113, "c6")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_B9: %g' % x0.x)
        print('vitamin_B5: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

