
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B9")
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_B5")

# Set the objective function
m.setObjective(1.18*x1 + 8.37*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 5*x2 >= 31, "immune_support_index_min")
m.addConstr(14*x1 + 13*x2 >= 21, "energy_stability_index_min")
m.addConstr(4*x1 + 6*x2 >= 42, "digestive_support_index_min")
m.addConstr(-7*x1 + 8*x2 >= 0, "vitamin_ratio_constraint")
m.addConstr(7*x1 + 5*x2 <= 101, "immune_support_index_max")
m.addConstr(14*x1 + 13*x2 <= 61, "energy_stability_index_max")
m.addConstr(4*x1 + 6*x2 <= 113, "digestive_support_index_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B9: {x1.x}")
    print(f"Milligrams of Vitamin B5: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
