
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_B9", lb=0)
    x2 = model.addVar(name="milligrams_of_vitamin_B5", lb=0)

    # Define the objective function
    model.setObjective(1.18 * x1 + 8.37 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * x1 + 5 * x2 >= 31)
    model.addConstr(14 * x1 + 13 * x2 >= 21)
    model.addConstr(4 * x1 + 6 * x2 >= 42)
    model.addConstr(-7 * x1 + 8 * x2 >= 0)
    model.addConstr(7 * x1 + 5 * x2 <= 101)
    model.addConstr(14 * x1 + 13 * x2 <= 61)
    model.addConstr(4 * x1 + 6 * x2 <= 113)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B9: {x1.varValue}")
        print(f"Milligrams of vitamin B5: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
