
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
variables = {
    'staplers': model.addVar(vtype=GRB.INTEGER, name='staplers'),
    'headsets': model.addVar(vtype=GRB.INTEGER, name='headsets'),
    'planners': model.addVar(vtype=GRB.INTEGER, name='planners'),
    'blue pens': model.addVar(vtype=GRB.INTEGER, name='blue_pens'),
    'office chairs': model.addVar(vtype=GRB.INTEGER, name='office_chairs'),
    'smoke detectors': model.addVar(vtype=GRB.INTEGER, name='smoke_detectors')
}


# Set objective function
model.setObjective(7.67 * variables['staplers'] + 1.84 * variables['headsets'] + 4.52 * variables['planners'] + 8.41 * variables['blue pens'] + 6.13 * variables['office chairs'] + 4.21 * variables['smoke detectors'], GRB.MAXIMIZE)

# Add constraints
model.addConstr(14 * variables['headsets'] + 12 * variables['blue pens'] >= 24)
model.addConstr(variables['staplers'] + 12 * variables['blue pens'] >= 18)
model.addConstr(14 * variables['headsets'] + 8 * variables['planners'] + 7 * variables['office chairs'] >= 23)
model.addConstr(4 * variables['headsets'] + variables['planners'] >= 14)
model.addConstr(variables['planners'] + 4 * variables['blue pens'] >= 35)
model.addConstr(variables['staplers'] + variables['planners'] >= 26)
model.addConstr(4 * variables['blue pens'] + 10 * variables['office chairs'] >= 33)
model.addConstr(variables['planners'] + 10 * variables['office chairs'] >= 36)
model.addConstr(4 * variables['headsets'] + 13 * variables['smoke detectors'] >= 42)
model.addConstr(10 * variables['office chairs'] + 13 * variables['smoke detectors'] >= 25)
model.addConstr(variables['staplers'] + 10 * variables['office chairs'] >= 21)
model.addConstr(variables['staplers'] + 8 * variables['planners'] <= 104)
model.addConstr(variables['staplers'] + 7 * variables['smoke detectors'] <= 84)
model.addConstr(8 * variables['planners'] + 12 * variables['blue pens'] <= 150)
model.addConstr(7 * variables['office chairs'] + 7 * variables['smoke detectors'] <= 188)
model.addConstr(12 * variables['blue pens'] + 7 * variables['office chairs'] <= 81)
model.addConstr(variables['staplers'] + 14 * variables['headsets'] <= 122)
model.addConstr(14 * variables['headsets'] + 8 * variables['planners'] <= 137)
model.addConstr(variables['staplers'] + 7 * variables['office chairs'] <= 105)
model.addConstr(14 * variables['headsets'] + 12 * variables['blue pens'] <= 92)
model.addConstr(variables['staplers'] + variables['headsets'] + variables['planners'] + variables['blue pens'] + variables['office chairs'] + variables['smoke detectors'] <= 92)
model.addConstr(variables['planners'] + 13 * variables['smoke detectors'] <= 117)
model.addConstr(variables['planners'] + 10 * variables['office chairs'] <= 206)
model.addConstr(variables['staplers'] + 13 * variables['smoke detectors'] <= 61)
model.addConstr(4 * variables['blue pens'] + 13 * variables['smoke detectors'] <= 115)
model.addConstr(10 * variables['office chairs'] + 13 * variables['smoke detectors'] <= 136)
model.addConstr(variables['staplers'] + 4 * variables['headsets'] <= 222)
model.addConstr(variables['planners'] + 4 * variables['blue pens'] <= 145)
model.addConstr(4 * variables['headsets'] + 13 * variables['smoke detectors'] <= 159)
model.addConstr(variables['staplers'] + variables['planners'] <= 51)
model.addConstr(variables['staplers'] + variables['headsets'] + variables['planners'] + variables['blue pens'] + variables['office chairs'] + variables['smoke detectors'] <= 51)


model.addConstr(variables['staplers'] + 14 * variables['headsets'] + 8 * variables['planners'] + 12 * variables['blue pens'] + 7 * variables['office chairs'] + 7 * variables['smoke detectors'] <= 188)
model.addConstr(variables['staplers'] + 4 * variables['headsets'] + variables['planners'] + 4 * variables['blue pens'] + 10 * variables['office chairs'] + 13 * variables['smoke detectors'] <= 260)



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}.")

