
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="staplers", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="headsets", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="planners", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="blue_pens", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="office_chairs", vtype=gurobi.GRB.INTEGER)
x5 = m.addVar(name="smoke_detectors", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(7.67 * x0 + 1.84 * x1 + 4.52 * x2 + 8.41 * x3 + 6.13 * x4 + 4.21 * x5, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * x1 + 12 * x3 >= 24)
m.addConstr(x0 + 12 * x3 >= 18)
m.addConstr(14 * x1 + 8 * x2 + 7 * x4 >= 23)
m.addConstr(4 * x1 + x2 >= 14)
m.addConstr(x2 + 4 * x3 >= 35)
m.addConstr(x0 + x2 >= 26)
m.addConstr(4 * x3 + 10 * x4 >= 33)
m.addConstr(x2 + 10 * x4 >= 36)
m.addConstr(4 * x1 + 13 * x5 >= 42)
m.addConstr(10 * x4 + 13 * x5 >= 25)
m.addConstr(x0 + 10 * x4 >= 21)
m.addConstr(x0 + 8 * x2 <= 104)
m.addConstr(x0 + 7 * x5 <= 84)
m.addConstr(8 * x2 + 12 * x3 <= 150)
m.addConstr(7 * x4 + 7 * x5 <= 188)
m.addConstr(12 * x3 + 7 * x4 <= 81)
m.addConstr(x0 + 14 * x1 <= 122)
m.addConstr(14 * x1 + 8 * x2 <= 137)
m.addConstr(x0 + 7 * x4 <= 105)
m.addConstr(14 * x1 + 12 * x3 <= 92)
m.addConstr(x0 + x1 + x2 + x3 + x4 + x5 <= 92)
m.addConstr(x2 + 13 * x5 <= 117)
m.addConstr(x2 + 10 * x4 <= 206)
m.addConstr(x0 + 13 * x5 <= 61)
m.addConstr(4 * x3 + 13 * x5 <= 115)
m.addConstr(10 * x4 + 13 * x5 <= 136)
m.addConstr(x0 + 4 * x1 <= 222)
m.addConstr(x2 + 4 * x3 <= 145)
m.addConstr(4 * x1 + 13 * x5 <= 159)
m.addConstr(x0 + x2 <= 51)
m.addConstr(x0 + x1 + x2 + x3 + x4 + x5 <= 51)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Staplers: ", x0.varValue)
    print("Headsets: ", x1.varValue)
    print("Planners: ", x2.varValue)
    print("Blue Pens: ", x3.varValue)
    print("Office Chairs: ", x4.varValue)
    print("Smoke Detectors: ", x5.varValue)
else:
    print("The model is infeasible")
