
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")


# Set objective function
m.setObjective(1.5 * jean + 4.77 * dale + 6.25 * john + 9.38 * bobby + 5.78 * bill, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * bobby + 1 * bill >= 16)
m.addConstr(2 * jean + 1 * bill >= 17)
m.addConstr(6 * john + 8 * bobby >= 20)
m.addConstr(1 * dale + 1 * bill >= 21)
m.addConstr(6 * john + 8 * bobby + 1 * bill >= 20)
m.addConstr(2 * jean + 1 * dale + 6 * john + 8 * bobby + 1 * bill >= 20)
m.addConstr(7 * john + 1 * bill >= 29)
m.addConstr(7 * john + 5 * bobby >= 34)
m.addConstr(6 * jean + 5 * bobby >= 11)
m.addConstr(1 * dale + 5 * bobby >= 13)
m.addConstr(6 * jean + 1 * bill >= 19)
m.addConstr(1 * dale + 7 * john >= 25)
m.addConstr(6 * jean + 7 * john >= 29)
m.addConstr(6 * jean + 1 * dale + 7 * john + 5 * bobby + 1 * bill >= 29)
m.addConstr(1 * bobby + 8 * bill >= 36)
m.addConstr(5 * jean + 1 * dale >= 21)
m.addConstr(1 * dale + 8 * bill >= 28)
m.addConstr(5 * jean + 1 * bobby >= 35)
m.addConstr(4 * john + 1 * bobby >= 21)
m.addConstr(5 * jean + 1 * dale + 4 * john + 1 * bobby + 8 * bill >= 21)
# ... (rest of the constraints from the JSON)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

