
import gurobi as gp

# Define model
m = gp.Model()

# Define variables
x0 = m.addVar(lb=0, name="x0")  # hours worked by Jean
x1 = m.addVar(lb=0, name="x1")  # hours worked by Dale
x2 = m.addVar(lb=0, name="x2")  # hours worked by John
x3 = m.addVar(lb=0, name="x3")  # hours worked by Bobby
x4 = m.addVar(lb=0, name="x4")  # hours worked by Bill

# Define objective function
m.setObjective(1.5*x0 + 4.77*x1 + 6.25*x2 + 9.38*x3 + 5.78*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 + 0*x1 + 6*x2 + 8*x3 + x4 >= 20) 
m.addConstr(x0 + 0*x1 + 0*x2 + 0*x3 + x4 >= 17) 
m.addConstr(0*x0 + x1 + 0*x2 + 0*x3 + x4 >= 21)
m.addConstr(6*x2 + 8*x3 >= 20)
m.addConstr(5*x0 + x1 >= 21)
m.addConstr(x1 + 8*x4 >= 28)
m.addConstr(5*x0 + x3 >= 35)
m.addConstr(4*x2 + x3 >= 21)
m.addConstr(7*x1 + 5*x2 >= 10)
m.addConstr(7*x0 + 6*x3 >= 11)

# ... add all constraints

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Jean: ", x0.varValue)
    print("Hours worked by Dale: ", x1.varValue)
    print("Hours worked by John: ", x2.varValue)
    print("Hours worked by Bobby: ", x3.varValue)
    print("Hours worked by Bill: ", x4.varValue)
else:
    print("No solution found")
