
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("pie_optimization")

    # Create variables
    apple_pies = model.addVar(vtype=gp.GRB.INTEGER, name="apple_pies")
    blueberry_pies = model.addVar(vtype=gp.GRB.INTEGER, name="blueberry_pies")

    # Set objective function
    model.setObjective(4.17 * apple_pies + 6.08 * blueberry_pies, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3.95 * apple_pies + 6.48 * blueberry_pies >= 73, "fiber_min")
    model.addConstr(12.08 * apple_pies + 1.48 * blueberry_pies >= 58, "protein_min")
    model.addConstr(13.27 * apple_pies + 7.25 * blueberry_pies >= 56, "cost_min")
    model.addConstr(12.13 * apple_pies + 12.43 * blueberry_pies >= 38, "iron_min")
    model.addConstr(12.81 * apple_pies + 2.93 * blueberry_pies >= 94, "tastiness_min")
    model.addConstr(5 * apple_pies - 4 * blueberry_pies >= 0, "apple_blueberry_ratio")

    model.addConstr(3.95 * apple_pies + 6.48 * blueberry_pies <= 83, "fiber_max")
    model.addConstr(12.08 * apple_pies + 1.48 * blueberry_pies <= 172, "protein_max")
    model.addConstr(13.27 * apple_pies + 7.25 * blueberry_pies <= 218, "cost_max")
    model.addConstr(12.13 * apple_pies + 12.43 * blueberry_pies <= 89, "iron_max")
    model.addConstr(12.81 * apple_pies + 2.93 * blueberry_pies <= 119, "tastiness_max")

    model.addConstr(3.95 * apple_pies + 6.48 * blueberry_pies <= 164, "fiber_upper_bound")
    model.addConstr(12.08 * apple_pies + 1.48 * blueberry_pies <= 197, "protein_upper_bound")
    model.addConstr(13.27 * apple_pies + 7.25 * blueberry_pies <= 229, "cost_upper_bound")
    model.addConstr(12.13 * apple_pies + 12.43 * blueberry_pies <= 117, "iron_upper_bound")
    model.addConstr(12.81 * apple_pies + 2.93 * blueberry_pies <= 203, "tastiness_upper_bound")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('apple_pies:', apple_pies.x)
        print('blueberry_pies:', blueberry_pies.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
