
from gurobipy import *

# Create a new model
m = Model("Pie_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
x2 = m.addVar(vtype=GRB.INTEGER, name="blueberry_pies")

# Objective function: maximize 4.17*x1 + 6.08*x2
m.setObjective(4.17*x1 + 6.08*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(3.95*x1 + 6.48*x2 >= 73)
m.addConstr(3.95*x1 + 6.48*x2 <= 83)
m.addConstr(12.08*x1 + 1.48*x2 >= 58)
m.addConstr(12.08*x1 + 1.48*x2 <= 172)
m.addConstr(13.27*x1 + 7.25*x2 >= 56)
m.addConstr(13.27*x1 + 7.25*x2 <= 218)
m.addConstr(12.13*x1 + 12.43*x2 >= 38)
m.addConstr(12.13*x1 + 12.43*x2 <= 89)
m.addConstr(12.81*x1 + 2.93*x2 >= 94)
m.addConstr(12.81*x1 + 2.93*x2 <= 119)
m.addConstr(5*x1 - 4*x2 >= 0)

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of apple pies: {x1.x}")
    print(f"Number of blueberry pies: {x2.x}")
else:
    print("No optimal solution found")
