
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="apple_pies", vtype=gurobi.GRB.INTEGER)  # apple pies
x1 = model.addVar(name="blueberry_pies", vtype=gurobi.GRB.INTEGER)  # blueberry pies

# Define the objective function
model.setObjective(4.17 * x0 + 6.08 * x1, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(3.95 * x0 + 6.48 * x1 >= 73, name="fiber_constraint")
model.addConstr(12.08 * x0 + 1.48 * x1 >= 58, name="protein_constraint")
model.addConstr(13.27 * x0 + 7.25 * x1 >= 56, name="cost_constraint")
model.addConstr(12.13 * x0 + 12.43 * x1 >= 38, name="iron_constraint")
model.addConstr(12.81 * x0 + 2.93 * x1 >= 94, name="tastiness_rating_constraint")
model.addConstr(5 * x0 - 4 * x1 >= 0, name="pie_ratio_constraint")
model.addConstr(3.95 * x0 + 6.48 * x1 <= 83, name="fiber_upper_bound_constraint")
model.addConstr(12.08 * x0 + 1.48 * x1 <= 172, name="protein_upper_bound_constraint")
model.addConstr(13.27 * x0 + 7.25 * x1 <= 218, name="cost_upper_bound_constraint")
model.addConstr(12.13 * x0 + 12.43 * x1 <= 89, name="iron_upper_bound_constraint")
model.addConstr(12.81 * x0 + 2.93 * x1 <= 119, name="tastiness_rating_upper_bound_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Apple pies: ", x0.varValue)
    print("Blueberry pies: ", x1.varValue)
else:
    print("The model is infeasible")
