
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_hours")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="John_hours")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="Peggy_hours")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="Mary_hours")


    # Set objective function
    model.setObjective(2.18 * x0 + 6.25 * x1 + 8.27 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * x0 + 4 * x1 + 18 * x2 >= 36, "c0")
    model.addConstr(19 * x0 + 13 * x1 >= 27, "c1")
    model.addConstr(6 * x0 + 18 * x2 <= 75, "c2")
    model.addConstr(6 * x0 + 4 * x1 + 18 * x2 <= 102, "c3")
    model.addConstr(11 * x1 + 6 * x2 <= 48, "c4")
    model.addConstr(1 * x0 + 6 * x2 <= 74, "c5")
    model.addConstr(1 * x0 + 11 * x1 + 6 * x2 <= 98, "c6")
    model.addConstr(19 * x0 + 13 * x1 <= 46, "c7")
    model.addConstr(19 * x0 + 7 * x2 <= 131, "c8")
    model.addConstr(19 * x0 + 13 * x1 + 7 * x2 <= 134, "c9")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
