
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by John
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Mary

    # Objective function
    model.setObjective(2.18 * x0 + 6.25 * x1 + 8.27 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * x0 >= 6, name="john_computer")
    model.addConstr(1 * x0 >= 1, name="john_productivity")
    model.addConstr(19 * x0 >= 19, name="john_cost")

    model.addConstr(4 * x1 >= 4, name="peggy_computer")
    model.addConstr(11 * x1 >= 11, name="peggy_productivity")
    model.addConstr(13 * x1 >= 13, name="peggy_cost")

    model.addConstr(18 * x2 >= 18, name="mary_computer")
    model.addConstr(6 * x2 >= 6, name="mary_productivity")
    model.addConstr(7 * x2 >= 7, name="mary_cost")

    model.addConstr(6 * x0 + 4 * x1 + 18 * x2 >= 36, name="total_computer")
    model.addConstr(19 * x0 + 13 * x1 >= 27, name="total_cost_john_peggy")
    model.addConstr(6 * x0 + 18 * x2 <= 75, name="total_computer_john_mary")
    model.addConstr(6 * x0 + 4 * x1 + 18 * x2 <= 102, name="total_computer_all")
    model.addConstr(11 * x1 + 6 * x2 <= 48, name="total_productivity_peggy_mary")
    model.addConstr(1 * x0 + 6 * x2 <= 74, name="total_productivity_john_mary")
    model.addConstr(1 * x0 + 11 * x1 + 6 * x2 <= 98, name="total_productivity_all")
    model.addConstr(19 * x0 + 13 * x1 <= 46, name="total_cost_john_peggy_max")
    model.addConstr(19 * x0 + 7 * x2 <= 131, name="total_cost_john_mary")
    model.addConstr(19 * x0 + 13 * x1 + 7 * x2 <= 134, name="total_cost_all")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
