
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="ham_sandwiches", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="bowls_of_cereal", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="black_beans", vtype=gurobi.GRB.INTEGER)

# Set the objective function
m.setObjective(7.18*x1*x2 + 6.24*x2**2 + 6.71*x2*x3, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x1 + 10*x2 >= 26)
m.addConstr(8*x1 + 13*x3 >= 26)
m.addConstr(10*x2 + 13*x3 >= 34)
m.addConstr(8*x1 + 10*x2 + 13*x3 >= 34)
m.addConstr(4*x1 - 3*x3 >= 0)
m.addConstr(10*x2 + 13*x3 <= 97)
m.addConstr(8*x1 + 10*x2 <= 78)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ham sandwiches: ", x1.varValue)
    print("Bowls of cereal: ", x2.varValue)
    print("Black beans: ", x3.varValue)
else:
    print("The model is infeasible")
