
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    vitamin_d = m.addVar(lb=0.0, name="vitamin_d")  # Continuous
    protein = m.addVar(lb=0.0, vtype=gp.GRB.INTEGER, name="protein") # Integer

    # Set objective function
    m.setObjective(8.27 * vitamin_d + 9.25 * protein, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2.3 * vitamin_d + 0.28 * protein >= 22, "muscle_growth_min")
    m.addConstr(0.95 * vitamin_d + 1.94 * protein >= 15, "energy_stability_min")
    m.addConstr(2.92 * vitamin_d + 0.58 * protein >= 12, "immune_support_min")
    m.addConstr(-8 * vitamin_d + 10 * protein >= 0, "vitamin_protein_ratio")
    m.addConstr(2.3 * vitamin_d + 0.28 * protein <= 55, "muscle_growth_max")
    m.addConstr(0.95 * vitamin_d + 1.94 * protein <= 60, "energy_stability_max")
    m.addConstr(2.92 * vitamin_d + 0.58 * protein <= 44, "immune_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        print('Vitamin D:', vitamin_d.x)
        print('Protein:', protein.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
