
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_D", lb=0, ub=None)
    x2 = model.addVar(name="grams_of_protein", lb=0, integer=True)

    # Define the objective function
    model.setObjective(8.27 * x1 + 9.25 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(2.3 * x1 + 0.28 * x2 >= 22, name="muscle_growth_index_constraint")
    model.addConstr(0.95 * x1 + 1.94 * x2 >= 15, name="energy_stability_index_constraint")
    model.addConstr(2.92 * x1 + 0.58 * x2 >= 12, name="immune_support_index_constraint")
    model.addConstr(-8 * x1 + 10 * x2 >= 0, name="protein_constraint")
    model.addConstr(2.3 * x1 + 0.28 * x2 <= 55, name="muscle_growth_index_upper_bound")
    model.addConstr(0.95 * x1 + 1.94 * x2 <= 60, name="energy_stability_index_upper_bound")
    model.addConstr(2.92 * x1 + 0.58 * x2 <= 44, name="immune_support_index_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x1.varValue}")
        print(f"Grams of protein: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
