
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
laura = m.addVar(vtype=GRB.INTEGER, name="laura")
ringo = m.addVar(vtype=GRB.INTEGER, name="ringo")
john = m.addVar(name="john")
paul = m.addVar(vtype=GRB.INTEGER, name="paul")
hank = m.addVar(vtype=GRB.INTEGER, name="hank")
george = m.addVar(vtype=GRB.INTEGER, name="george")


# Set objective function
m.setObjective(9.65*laura*ringo + 7.47*laura*john + 6.82*laura*hank + 6.51*laura*george + 7.67*ringo**2 + 3.64*ringo*hank + 1.08*ringo*george + 9.24*john**2 + 9.39*john*hank + 1.46*john*george + 8.24*paul**2 + 7.27*paul*george + 9.2*hank**2 + 6.82*hank*george + 1.5*george**2 + 9.53*ringo + 1.88*john + 8.03*hank + 6.24*george, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*ringo**2 + 1*paul**2 + 10*george**2 >= 15)
m.addConstr(6*laura + 11*john + 7*hank >= 15)
m.addConstr(6*laura**2 + 9*ringo**2 + 1*paul**2 >= 15)
m.addConstr(9*ringo**2 + 1*paul**2 + 10*george**2 >= 18)
m.addConstr(6*laura + 11*john + 7*hank >= 18)
m.addConstr(6*laura**2 + 9*ringo**2 + 1*paul**2 >= 18)
m.addConstr(9*ringo**2 + 1*paul**2 + 10*george**2 >= 10)
m.addConstr(6*laura + 11*john + 7*hank >= 10)
m.addConstr(6*laura**2 + 9*ringo**2 + 1*paul**2 >= 10)
m.addConstr(6*john - 3*george >= 0)
m.addConstr(9*ringo**2 + 1*paul**2 <= 47)
m.addConstr(9*ringo**2 + 10*george**2 <= 63)
m.addConstr(6*laura + 10*george <= 56)
m.addConstr(7*hank + 10*george <= 111)
m.addConstr(6*laura**2 + 9*ringo**2 <= 62)
m.addConstr(6*laura + 11*john <= 110)
m.addConstr(11*john + 1*paul <= 28)
m.addConstr(9*ringo + 11*john + 1*paul <= 97)
m.addConstr(6*laura + 1*paul + 7*hank <= 74)
m.addConstr(6*laura + 9*ringo + 11*john + 1*paul + 7*hank + 10*george <= 74)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

