
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="x1")  # Laura
    x2 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="x2")  # Ringo
    x3 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS, name="x3")  # John
    x4 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="x4")  # Paul
    x5 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="x5")  # Hank
    x6 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="x6")  # George

    # Set initial values
    x1.Start = 6
    x2.Start = 9
    x3.Start = 11
    x4.Start = 1
    x5.Start = 7
    x6.Start = 10

    # Objective function
    model.setObjective(9.65*x1*x2 + 7.47*x1*x3 + 6.82*x1*x5 + 6.51*x1*x6 + 7.67*x2**2 + 3.64*x2*x5 + 1.08*x2*x6 + 9.24*x3**2 + 9.39*x3*x5 + 1.46*x3*x6 + 8.24*x4**2 + 7.27*x4*x6 + 9.2*x5**2 + 6.82*x5*x6 + 1.5*x6**2 + 9.53*x2 + 1.88*x3 + 8.03*x5 + 6.24*x6, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 == 6)
    model.addConstr(x2 == 9)
    model.addConstr(x3 == 11)
    model.addConstr(x4 == 1)
    model.addConstr(x5 == 7)
    model.addConstr(x6 == 10)
    model.addConstr(x2**2 + x4**2 + x6**2 >= 15)
    model.addConstr(x1 + x3 + x5 >= 15)
    model.addConstr(x1**2 + x2**2 + x4**2 >= 15)
    model.addConstr(x2**2 + x4**2 + x6**2 >= 18)
    model.addConstr(x1 + x3 + x5 >= 18)
    model.addConstr(x1**2 + x2**2 + x4**2 >= 18)
    model.addConstr(x2**2 + x4**2 + x6**2 >= 10)
    model.addConstr(x1 + x3 + x5 >= 10)
    model.addConstr(x1**2 + x2**2 + x4**2 >= 10)
    model.addConstr(6*x3 - 3*x6 >= 0)
    model.addConstr(x2**2 + x4**2 <= 47)
    model.addConstr(x2**2 + x6**2 <= 63)
    model.addConstr(x1 + x6 <= 56)
    model.addConstr(x5 + x6 <= 111)
    model.addConstr(x1**2 + x2**2 <= 62)
    model.addConstr(x1 + x3 <= 110)
    model.addConstr(x3 + x4 <= 28)
    model.addConstr(x2 + x3 + x4 <= 97)
    model.addConstr(x1 + x4 + x5 <= 74)
    model.addConstr(x1 + x2 + x3 + x4 + x5 + x6 <= 74)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("No solution found")

optimization_problem()
