
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, names=["George", "Peggy", "Laura", "Mary"])

    # Set objective function
    m.setObjective(5*x[0] + 1*x[1] + 9*x[2] + 4*x[3], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4*x[1] + 29*x[3] >= 76)
    m.addConstr(13*x[0] + 4*x[1] >= 45)
    m.addConstr(13*x[0] + 6*x[2] >= 82)
    m.addConstr(13*x[0] + 29*x[3] >= 60)
    m.addConstr(6*x[2] + 29*x[3] >= 59)
    m.addConstr(4*x[1] + 6*x[2] + 29*x[3] >= 58)
    m.addConstr(13*x[0] + 6*x[2] + 29*x[3] >= 58)
    m.addConstr(4*x[1] + 6*x[2] + 29*x[3] >= 57)
    m.addConstr(13*x[0] + 6*x[2] + 29*x[3] >= 57)
    m.addConstr(13*x[0] + 4*x[1] + 6*x[2] + 29*x[3] >= 57)
    m.addConstr(4*x[0] + 7*x[3] >= 118)
    m.addConstr(4*x[0] + 7*x[2] >= 50)
    m.addConstr(16*x[1] + 7*x[2] >= 67)
    m.addConstr(4*x[0] + 7*x[2] + 7*x[3] >= 64)
    m.addConstr(4*x[0] + 16*x[1] + 7*x[2] + 7*x[3] >= 64)
    m.addConstr(4*x[0] - 7*x[1] >= 0)
    m.addConstr(13*x[0] + 6*x[2] <= 156)
    m.addConstr(13*x[0] + 4*x[1] + 6*x[2] <= 270)
    m.addConstr(4*x[0] + 16*x[1] <= 391)
    m.addConstr(16*x[1] + 7*x[3] <= 317)
    m.addConstr(16*x[1] + 7*x[2] <= 357)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f"{v.varName} = {v.x}")
        print(f"Obj: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
