
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_George", lb=0)  # George
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)  # Peggy
x2 = m.addVar(name="hours_worked_by_Laura", lb=0)  # Laura
x3 = m.addVar(name="hours_worked_by_Mary", lb=0)  # Mary

# Objective function
m.setObjective(5 * x0 + x1 + 9 * x2 + 4 * x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(4 * x1 + 29 * x3 >= 76)
m.addConstr(13 * x0 + 4 * x1 >= 45)
m.addConstr(13 * x0 + 6 * x2 >= 82)
m.addConstr(13 * x0 + 29 * x3 >= 60)
m.addConstr(6 * x2 + 29 * x3 >= 59)
m.addConstr(4 * x1 + 6 * x2 + 29 * x3 >= 58)
m.addConstr(13 * x0 + 6 * x2 + 29 * x3 >= 58)
m.addConstr(4 * x1 + 6 * x2 + 29 * x3 >= 57)
m.addConstr(13 * x0 + 6 * x2 + 29 * x3 >= 57)
m.addConstr(13 * x0 + 4 * x1 + 6 * x2 + 29 * x3 >= 57)
m.addConstr(4 * x0 + 7 * x3 >= 118)
m.addConstr(4 * x0 + 7 * x2 >= 50)
m.addConstr(16 * x1 + 7 * x2 >= 67)
m.addConstr(4 * x0 + 7 * x2 + 7 * x3 >= 64)
m.addConstr(4 * x0 + 16 * x1 + 7 * x2 + 7 * x3 >= 64)
m.addConstr(4 * x0 - 7 * x1 >= 0)
m.addConstr(13 * x0 + 6 * x2 <= 156)
m.addConstr(13 * x0 + 4 * x1 + 6 * x2 <= 270)
m.addConstr(4 * x0 + 16 * x1 <= 391)
m.addConstr(16 * x1 + 7 * x3 <= 317)
m.addConstr(16 * x1 + 7 * x2 <= 357)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", x0.varValue)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
    print("Hours worked by Mary: ", x3.varValue)
else:
    print("The model is infeasible")
