
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of zinc
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1")  # grams of fat
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2")  # milligrams of iron
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3")  # milligrams of vitamin K
    x4 = m.addVar(vtype=gp.GRB.INTEGER, name="x4")  # milligrams of vitamin B5


    # Set objective function
    m.setObjective(6*x0 + 1*x1 + 5*x2 + 8*x3 + 8*x4, gp.GRB.MINIMIZE)

    # Add constraints
    constraints = [
       
    ]
    
    for constraint in constraints_data['constraints']:
        m.addConstr(eval(constraint))


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
