
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
    bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
    bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
    george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")

    # Set objective function
    model.setObjective(7*peggy + 6*bobby + 4*bill + 4*george, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.56*peggy + 0.41*bill <= 137, "c0")
    model.addConstr(0.61*bobby + 1.81*george <= 121, "c1")
    model.addConstr(0.56*peggy + 0.61*bobby <= 163, "c2")
    model.addConstr(0.41*bill + 1.81*george <= 181, "c3")
    model.addConstr(0.56*peggy + 0.61*bobby + 0.41*bill + 1.81*george <= 181, "c4")
    model.addConstr(0.29*bobby + 0.09*george <= 111, "c5")
    model.addConstr(0.47*peggy + 1.32*bill <= 33, "c6")
    model.addConstr(0.47*peggy + 0.09*george <= 82, "c7")
    model.addConstr(1.32*bill + 0.09*george <= 78, "c8")
    model.addConstr(0.47*peggy + 0.29*bobby + 1.32*bill + 0.09*george <= 78, "c9")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
