
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Peggy
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bobby
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Bill
    x3 = model.addVar(name="x3", lb=0)  # hours worked by George

    # Define the objective function
    model.setObjective(7 * x0 + 6 * x1 + 4 * x2 + 4 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.56 * x0 <= 222)
    model.addConstr(0.47 * x0 <= 124)
    model.addConstr(0.61 * x1 <= 222)
    model.addConstr(0.29 * x1 <= 124)
    model.addConstr(0.41 * x2 <= 222)
    model.addConstr(1.32 * x2 <= 124)
    model.addConstr(1.81 * x3 <= 222)
    model.addConstr(0.09 * x3 <= 124)
    model.addConstr(0.56 * x0 + 0.41 * x2 <= 137)
    model.addConstr(0.61 * x1 + 1.81 * x3 <= 121)
    model.addConstr(0.56 * x0 + 0.61 * x1 <= 163)
    model.addConstr(0.41 * x2 + 1.81 * x3 <= 181)
    model.addConstr(0.56 * x0 + 0.61 * x1 + 0.41 * x2 + 1.81 * x3 <= 181)
    model.addConstr(0.29 * x1 + 0.09 * x3 <= 111)
    model.addConstr(0.47 * x0 + 1.32 * x2 <= 33)
    model.addConstr(0.47 * x0 + 0.09 * x3 <= 82)
    model.addConstr(1.32 * x2 + 0.09 * x3 <= 78)
    model.addConstr(0.47 * x0 + 0.29 * x1 + 1.32 * x2 + 0.09 * x3 <= 78)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Peggy: ", x0.varValue)
        print("Hours worked by Bobby: ", x1.varValue)
        print("Hours worked by Bill: ", x2.varValue)
        print("Hours worked by George: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
