
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="bowls_of_pasta", lb=-gurobi.GRB.INFINITY)
    x1 = model.addVar(name="oranges", lb=-gurobi.GRB.INFINITY)
    x2 = model.addVar(name="tomatoes", lb=-gurobi.GRB.INFINITY)
    x3 = model.addVar(name="ravioli", lb=-gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(7 * x0 + 3 * x1 + 7 * x2 + 5 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(18 * x0 + 6 * x2 >= 14)
    model.addConstr(18 * x0 + 18 * x1 >= 15)
    model.addConstr(18 * x0 + 6 * x2 + 16 * x3 >= 24)
    model.addConstr(18 * x1 + 6 * x2 + 16 * x3 >= 24)
    model.addConstr(18 * x0 + 6 * x2 + 16 * x3 >= 38)
    model.addConstr(18 * x1 + 6 * x2 + 16 * x3 >= 38)
    model.addConstr(18 * x0 + 18 * x1 + 6 * x2 + 16 * x3 >= 38)
    model.addConstr(4 * x0 + 19 * x3 >= 31)
    model.addConstr(6 * x2 + 19 * x3 >= 27)
    model.addConstr(4 * x0 + 9 * x1 >= 31)
    model.addConstr(9 * x1 + 6 * x2 >= 25)
    model.addConstr(4 * x0 + 9 * x1 + 6 * x2 >= 32)
    model.addConstr(4 * x0 + 6 * x2 + 19 * x3 >= 32)
    model.addConstr(4 * x0 + 9 * x1 + 6 * x2 >= 26)
    model.addConstr(4 * x0 + 6 * x2 + 19 * x3 >= 26)
    model.addConstr(4 * x0 + 9 * x1 + 6 * x2 + 19 * x3 >= 26)
    model.addConstr(6 * x1 - 4 * x2 >= 0)
    model.addConstr(18 * x1 + 16 * x3 <= 149)
    model.addConstr(18 * x0 + 18 * x1 <= 124)
    model.addConstr(18 * x1 + 6 * x2 <= 139)
    model.addConstr(6 * x2 + 16 * x3 <= 72)
    model.addConstr(18 * x0 + 18 * x1 + 6 * x2 <= 159)
    model.addConstr(6 * x2 + 19 * x3 <= 56)
    model.addConstr(4 * x0 + 19 * x3 <= 42)
    model.addConstr(9 * x1 + 19 * x3 <= 108)
    model.addConstr(4 * x0 + 9 * x1 <= 122)
    model.addConstr(4 * x0 + 6 * x2 + 19 * x3 <= 113)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("bowls_of_pasta: ", x0.varValue)
        print("oranges: ", x1.varValue)
        print("tomatoes: ", x2.varValue)
        print("ravioli: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
