
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B2
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # grams of fat
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2") # grams of carbohydrates
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3") # milligrams of iron


    # Set objective function
    m.setObjective(8*x0 + 3*x1 + x2 + 4*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x0 + 9*x1 >= 49)
    m.addConstr(9*x1 + 4*x2 >= 61)
    m.addConstr(x0 + 4*x2 >= 21)
    m.addConstr(x0 + 11*x3 >= 32)
    m.addConstr(8*x0 + x1 >= 57)
    m.addConstr(8*x0 + 6*x2 + 11*x3 >= 51)
    m.addConstr(8*x0 + x1 + 6*x2 >= 51)
    m.addConstr(8*x0 + x1 + 11*x3 >= 51)
    m.addConstr(8*x0 + 6*x2 + 11*x3 >= 36)
    m.addConstr(8*x0 + x1 + 6*x2 >= 36)
    m.addConstr(8*x0 + x1 + 11*x3 >= 36)
    m.addConstr(8*x0 + 6*x2 + 11*x3 >= 40)
    m.addConstr(8*x0 + x1 + 6*x2 >= 40)
    m.addConstr(8*x0 + x1 + 11*x3 >= 40)
    m.addConstr(4*x2 + 11*x3 <= 237)
    m.addConstr(x0 + 9*x1 + 4*x2 <= 94)
    m.addConstr(x0 + 4*x2 + 11*x3 <= 174)
    m.addConstr(x0 + 9*x1 + 11*x3 <= 197)
    m.addConstr(x0 + 9*x1 + 4*x2 + 11*x3 <= 197)
    m.addConstr(x1 + 6*x2 <= 174)
    m.addConstr(8*x0 + 11*x3 <= 201)
    m.addConstr(8*x0 + x1 <= 205)
    m.addConstr(6*x2 + 11*x3 <= 114)
    m.addConstr(8*x0 + x1 + 11*x3 <= 243)
    m.addConstr(8*x0 + x1 + 6*x2 + 11*x3 <= 243)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
