
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="x1")  # milligrams of vitamin B2
    x2 = model.addVar(lb=0, name="x2")  # grams of fat
    x3 = model.addVar(lb=0, type=gurobi.GRB.INTEGER, name="x3")  # grams of carbohydrates
    x4 = model.addVar(lb=0, type=gurobi.GRB.INTEGER, name="x4")  # milligrams of iron

    # Objective function
    model.setObjective(8*x1 + 3*x2 + x3 + 4*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + 9*x2 >= 49)
    model.addConstr(9*x2 + 4*x3 >= 61)
    model.addConstr(x1 + 4*x3 >= 21)
    model.addConstr(x1 + 11*x4 >= 32)
    model.addConstr(8*x1 + x2 >= 57)
    model.addConstr(8*x1 + 6*x3 + 11*x4 >= 51)
    model.addConstr(8*x1 + x2 + 6*x3 >= 51)
    model.addConstr(8*x1 + x2 + 11*x4 >= 51)
    model.addConstr(8*x1 + x3 + 11*x4 >= 36)
    model.addConstr(8*x1 + x2 + x3 >= 36)
    model.addConstr(8*x1 + x2 + 11*x4 >= 36)
    model.addConstr(8*x1 + 6*x3 + 11*x4 >= 40)
    model.addConstr(8*x1 + x2 + x3 >= 40)
    model.addConstr(8*x1 + x2 + 11*x4 >= 40)
    model.addConstr(4*x3 + 11*x4 <= 237)
    model.addConstr(x1 + 9*x2 + 4*x3 <= 94)
    model.addConstr(x1 + 4*x3 + 11*x4 <= 174)
    model.addConstr(x1 + 9*x2 + 11*x4 <= 197)
    model.addConstr(x1 + 9*x2 + 4*x3 + 11*x4 <= 197)
    model.addConstr(x2 + 6*x3 <= 174)
    model.addConstr(8*x1 + 11*x4 <= 201)
    model.addConstr(8*x1 + x2 <= 205)
    model.addConstr(6*x3 + 11*x4 <= 114)
    model.addConstr(8*x1 + x2 + 11*x4 <= 243)
    model.addConstr(8*x1 + x2 + x3 + 11*x4 <= 243)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B2: {x1.varValue}")
        print(f"Grams of fat: {x2.varValue}")
        print(f"Grams of carbohydrates: {x3.varValue}")
        print(f"Milligrams of iron: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
