
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean = m.addVar(vtype=gp.GRB.INTEGER, name="jean")
mary = m.addVar(vtype=gp.GRB.INTEGER, name="mary")
ringo = m.addVar(vtype=gp.GRB.INTEGER, name="ringo")
bobby = m.addVar(vtype=gp.GRB.INTEGER, name="bobby")
george = m.addVar(vtype=gp.GRB.INTEGER, name="george")


# Set objective function
m.setObjective(5*jean + 6*mary + 6*ringo + 7*bobby + 3*george, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(23*ringo + 6*bobby >= 89)
m.addConstr(6*mary + 7*george >= 81)
m.addConstr(20*jean + 6*bobby >= 52)
m.addConstr(20*jean + 7*george >= 64)
m.addConstr(23*ringo + 7*george >= 88)
m.addConstr(6*mary + 6*bobby >= 88)
m.addConstr(6*mary + 23*ringo + 6*bobby >= 66)
m.addConstr(20*jean + 6*mary + 7*george >= 66)
m.addConstr(20*jean + 23*ringo + 6*bobby >= 66)
m.addConstr(20*jean + 6*mary + 23*ringo >= 66)
m.addConstr(6*mary + 23*ringo + 6*bobby >= 65)
m.addConstr(20*jean + 6*mary + 7*george >= 65)
m.addConstr(20*jean + 23*ringo + 6*bobby >= 65)
m.addConstr(20*jean + 6*mary + 23*ringo >= 65)
m.addConstr(6*mary + 23*ringo + 6*bobby >= 85)
m.addConstr(20*jean + 6*mary + 7*george >= 85)
m.addConstr(20*jean + 23*ringo + 6*bobby >= 85)
m.addConstr(20*jean + 6*mary + 23*ringo >= 85)
m.addConstr(6*mary + 23*ringo + 6*bobby >= 96)
m.addConstr(20*jean + 6*mary + 7*george >= 96)
m.addConstr(20*jean + 23*ringo + 6*bobby >= 96)
m.addConstr(20*jean + 6*mary + 23*ringo >= 96)
m.addConstr(20*jean + 6*mary + 23*ringo + 6*bobby + 7*george >= 96)
m.addConstr(4*jean + 7*bobby + 25*george >= 90)
m.addConstr(20*mary + 27*ringo + 7*bobby >= 90)
m.addConstr(4*jean + 20*mary + 7*bobby >= 90)
m.addConstr(4*jean + 27*ringo + 7*bobby >= 90)
m.addConstr(20*mary + 27*ringo + 25*george >= 90)
m.addConstr(20*mary + 7*bobby + 25*george >= 90)
m.addConstr(4*jean + 27*ringo + 25*george >= 90)
# ... (rest of productivity constraints - similar structure)
m.addConstr(-5*mary + 6*george >= 0)
m.addConstr(20*jean + 6*bobby <= 295)
m.addConstr(23*ringo + 7*george <= 213)
m.addConstr(6*mary + 6*bobby <= 205)
m.addConstr(20*jean + 23*ringo <= 147)
m.addConstr(20*jean + 6*mary <= 171)
m.addConstr(6*mary + 23*ringo <= 395)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

