
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="bowls of cereal")
    x1 = m.addVar(name="bagged salads")
    x2 = m.addVar(name="bananas")
    x3 = m.addVar(name="sashimi")


    # Set objective function
    m.setObjective(8.23*x0 + 6.31*x1 + 5.0*x2 + 1.13*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3*x0 + 8*x1 + 7*x2 >= 23)
    m.addConstr(3*x0 + 8*x1 + 15*x3 >= 23)
    m.addConstr(3*x0 + 8*x1 + 7*x2 >= 21)
    m.addConstr(3*x0 + 8*x1 + 15*x3 >= 21)
    m.addConstr(2*x1 + 17*x3 >= 22)
    m.addConstr(12*x0 + 17*x3 >= 17)
    m.addConstr(12*x0 + 10*x2 >= 34)
    m.addConstr(12*x0 + 2*x1 >= 14)
    m.addConstr(12*x0 + 2*x1 + 10*x2 >= 24)
    m.addConstr(12*x0 + 2*x1 + 17*x3 >= 24)
    m.addConstr(2*x1 + 10*x2 + 17*x3 >= 24)
    m.addConstr(12*x0 + 2*x1 + 10*x2 >= 17)
    m.addConstr(12*x0 + 2*x1 + 17*x3 >= 17)
    m.addConstr(2*x1 + 10*x2 + 17*x3 >= 17)
    m.addConstr(12*x0 + 2*x1 + 10*x2 >= 29)
    m.addConstr(12*x0 + 2*x1 + 17*x3 >= 29)
    m.addConstr(2*x1 + 10*x2 + 17*x3 >= 29)
    m.addConstr(-2*x0 + 10*x3 >= 0)
    m.addConstr(8*x1 + 7*x2 <= 121)
    m.addConstr(3*x0 + 7*x2 <= 122)
    m.addConstr(3*x0 + 8*x1 + 7*x2 + 15*x3 <= 122)
    m.addConstr(12*x0 + 2*x1 <= 121)
    m.addConstr(12*x0 + 17*x3 <= 61)
    m.addConstr(2*x1 + 10*x2 <= 138)
    m.addConstr(12*x0 + 2*x1 + 17*x3 <= 101)
    m.addConstr(12*x0 + 2*x1 + 10*x2 + 17*x3 <= 101)


    # Resource Constraints
    m.addConstr(3*x0 <= 172, "r0_cereal")
    m.addConstr(12*x0 <= 140, "r1_cereal")
    m.addConstr(8*x1 <= 172, "r0_salad")
    m.addConstr(2*x1 <= 140, "r1_salad")
    m.addConstr(7*x2 <= 172, "r0_bananas")
    m.addConstr(10*x2 <= 140, "r1_bananas")
    m.addConstr(15*x3 <= 172, "r0_sashimi")
    m.addConstr(17*x3 <= 140, "r1_sashimi")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f"{v.varName}: {v.x}")
        print(f"Obj: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print(f"Error code {e.errno}: {e.message}")
except AttributeError:
    print('Encountered an attribute error')
