
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="bowls_of_cereal", lb=0)
    x1 = model.addVar(name="bagged_salads", lb=0)
    x2 = model.addVar(name="bananas", lb=0)
    x3 = model.addVar(name="sashimi", lb=0)

    # Define the objective function
    model.setObjective(8.23*x0 + 6.31*x1 + 5.0*x2 + 1.13*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x0 + 8*x1 + 7*x2 >= 23)
    model.addConstr(3*x0 + 8*x1 + 15*x3 >= 23)
    model.addConstr(3*x0 + 8*x1 + 7*x2 >= 21)
    model.addConstr(3*x0 + 8*x1 + 15*x3 >= 21)
    model.addConstr(2*x1 + 17*x3 >= 22)
    model.addConstr(12*x0 + 17*x3 >= 17)
    model.addConstr(12*x0 + 10*x2 >= 34)
    model.addConstr(12*x0 + 2*x1 >= 14)
    model.addConstr(12*x0 + 2*x1 + 10*x2 >= 24)
    model.addConstr(12*x0 + 2*x1 + 17*x3 >= 24)
    model.addConstr(2*x1 + 10*x2 + 17*x3 >= 24)
    model.addConstr(12*x0 + 2*x1 + 10*x2 >= 17)
    model.addConstr(12*x0 + 2*x1 + 17*x3 >= 17)
    model.addConstr(2*x1 + 10*x2 + 17*x3 >= 17)
    model.addConstr(12*x0 + 2*x1 + 10*x2 >= 29)
    model.addConstr(12*x0 + 2*x1 + 17*x3 >= 29)
    model.addConstr(2*x1 + 10*x2 + 17*x3 >= 29)
    model.addConstr(-2*x0 + 10*x3 >= 0)
    model.addConstr(8*x1 + 7*x2 <= 121)
    model.addConstr(3*x0 + 7*x2 <= 122)
    model.addConstr(3*x0 + 8*x1 + 7*x2 + 15*x3 <= 122)
    model.addConstr(12*x0 + 2*x1 <= 121)
    model.addConstr(12*x0 + 17*x3 <= 61)
    model.addConstr(2*x1 + 10*x2 <= 138)
    model.addConstr(12*x0 + 2*x1 + 17*x3 <= 101)
    model.addConstr(12*x0 + 2*x1 + 10*x2 + 17*x3 <= 101)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("bowls_of_cereal: ", x0.varValue)
        print("bagged_salads: ", x1.varValue)
        print("bananas: ", x2.varValue)
        print("sashimi: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
