
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Work_Hours")

# Create variables
hank = model.addVar(vtype=gp.GRB.INTEGER, name="hank")
peggy = model.addVar(vtype=gp.GRB.INTEGER, name="peggy")
ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")
george = model.addVar(vtype=gp.GRB.INTEGER, name="george")
mary = model.addVar(vtype=gp.GRB.INTEGER, name="mary")
dale = model.addVar(vtype=gp.GRB.INTEGER, name="dale")


# Set objective function
model.setObjective(4.9 * hank + 5.94 * peggy + 7.72 * ringo + 4.66 * george + 3.27 * mary + 1.6 * dale, gp.GRB.MINIMIZE)

# Add constraints

model.addConstr(26.28 * peggy + 23.64 * mary >= 52)
model.addConstr(23.64 * mary + 9.17 * dale >= 24)
model.addConstr(25.11 * george + 9.17 * dale >= 30)
model.addConstr(1.93 * hank + 25.11 * george >= 64)
model.addConstr(1.93 * hank + 23.64 * mary >= 43)
model.addConstr(1.93 * hank + 9.17 * dale >= 66)
model.addConstr(25.11 * george + 23.64 * mary + 9.17 * dale >= 62)
model.addConstr(1.93 * hank + 26.28 * peggy + 9.17 * dale >= 62)
model.addConstr(25.11 * george + 23.64 * mary + 9.17 * dale >= 55)
model.addConstr(1.93 * hank + 26.28 * peggy + 9.17 * dale >= 55)
model.addConstr(1.93 * hank + 26.28 * peggy + 18.04 * ringo + 25.11 * george + 23.64 * mary + 9.17 * dale >= 55)
model.addConstr(8.14 * peggy + 11.17 * mary >= 41)
model.addConstr(12.03 * hank + 16.01 * george >= 70)


# ... (rest of the constraints from the JSON)


model.addConstr(18.04 * ringo + 25.11 * george <= 368)
model.addConstr(23.64 * mary + 9.17 * dale <= 185)
# ... (rest of the upper bound constraints)

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

