
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Peggy")
x3 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Ringo")
x4 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")
x5 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")
x6 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Dale")

# Define objective function (example: minimize total hours)
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 >= 34, "total_hours_constraint")
m.addConstr(x4 + x5 + x6 <= 161, "quality_rating_constraint")
# ... add all other constraints similarly

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print("%s %f" % (v.varName, v.x))
else:
    print("No optimal solution found")
