
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # hours worked by Hank
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # hours worked by Peggy
x3 = m.addVar(name="x3", vtype=gp.GRB.INTEGER)  # hours worked by Ringo
x4 = m.addVar(name="x4", vtype=gp.GRB.INTEGER)  # hours worked by George
x5 = m.addVar(name="x5", vtype=gp.GRB.INTEGER)  # hours worked by Mary
x6 = m.addVar(name="x6", vtype=gp.GRB.INTEGER)  # hours worked by Dale

# Objective function
m.setObjective(4.9*x1 + 5.94*x2 + 7.72*x3 + 4.66*x4 + 3.27*x5 + 1.6*x6, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(1.93*x1 <= 412)
m.addConstr(12.03*x1 <= 572)
m.addConstr(16.87*x1 <= 395)
m.addConstr(26.28*x2 <= 412)
m.addConstr(8.14*x2 <= 572)
m.addConstr(26.55*x2 <= 395)
m.addConstr(18.04*x3 <= 412)
m.addConstr(0.55*x3 <= 572)
m.addConstr(19.94*x3 <= 395)
m.addConstr(25.11*x4 <= 412)
m.addConstr(16.01*x4 <= 572)
m.addConstr(7.94*x4 <= 395)
m.addConstr(23.64*x5 <= 412)
m.addConstr(11.17*x5 <= 572)
m.addConstr(19.26*x5 <= 395)
m.addConstr(9.17*x6 <= 412)
m.addConstr(11.0*x6 <= 572)
m.addConstr(25.72*x6 <= 395)
m.addConstr(26.28*x2 + 23.64*x5 >= 52)
m.addConstr(23.64*x5 + 9.17*x6 >= 24)
m.addConstr(25.11*x4 + 9.17*x6 >= 30)
m.addConstr(1.93*x1 + 25.11*x4 >= 64)
m.addConstr(1.93*x1 + 23.64*x5 >= 43)
m.addConstr(1.93*x1 + 9.17*x6 >= 66)
m.addConstr(25.11*x4 + 23.64*x5 + 9.17*x6 >= 62)
m.addConstr(26.28*x2 + 9.17*x6 >= 62)
m.addConstr(8.14*x2 + 11.17*x5 >= 41)
m.addConstr(12.03*x1 + 16.01*x4 >= 70)
m.addConstr(0.55*x3 + 12.03*x1 + 16.01*x4 >= 78)
m.addConstr(8.14*x2 + 16.01*x4 + 11.0*x6 >= 78)
m.addConstr(8.14*x2 + 0.55*x3 + 11.0*x6 >= 78)
m.addConstr(8.14*x2 + 0.55*x3 + 11.17*x5 >= 78)
m.addConstr(12.03*x1 + 0.55*x3 + 11.17*x5 >= 78)
m.addConstr(8.14*x2 + 11.17*x5 + 11.0*x6 >= 78)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Hank: ", x1.varValue)
    print("Hours worked by Peggy: ", x2.varValue)
    print("Hours worked by Ringo: ", x3.varValue)
    print("Hours worked by George: ", x4.varValue)
    print("Hours worked by Mary: ", x5.varValue)
    print("Hours worked by Dale: ", x6.varValue)
else:
    print("No optimal solution found")
