
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="strawberry bushes")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="begonias")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="pansies")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="carnations")


# Set objective function
m.setObjective(8*x0**2 + 9*x0*x1 + x0*x3 + x1**2 + 3*x1*x3 + 8*x2*x3 + 2*x3**2 + 3*x0 + 6*x2 + 7*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x0 + 24*x1 + 23*x2 + 4*x3 <= 375, "r0")
m.addConstr(19*x0 + 3*x1 + 6*x2 + 16*x3 <= 245, "r1")
m.addConstr(25*x0 + 15*x1 + 24*x2 + 9*x3 <= 179, "r2")
m.addConstr(2*x0 + 17*x1 + 1*x2 + 14*x3 <= 417, "r3")
m.addConstr(3*x0 + 24*x1 + 15*x2 + 2*x3 <= 220, "r4")
m.addConstr(24*x1**2 + 23*x2**2 >= 85, "c1")
m.addConstr(24*x1**2 + 4*x3**2 >= 64, "c2")
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

