
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="protein_bars")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="ham_sandwiches")


    # Set objective function
    model.setObjective(5.24 * x0 + 6.19 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(26 * x0 + 3 * x1 >= 47, "umami_index_min")
    model.addConstr(25 * x0 + 16 * x1 >= 66, "iron_min")
    model.addConstr(1 * x0 - 7 * x1 >= 0, "protein_bars_vs_ham_sandwiches")
    model.addConstr(26 * x0 + 3 * x1 <= 72, "umami_index_max")
    model.addConstr(25 * x0 + 16 * x1 <= 121, "iron_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Protein bars: {x0.x}")
        print(f"Ham sandwiches: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

