
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables
x0 = model.addVar(vtype=GRB.INTEGER, name="protein_bars")
x1 = model.addVar(vtype=GRB.INTEGER, name="ham_sandwiches")

# Set the objective function
model.setObjective(5.24*x0 + 6.19*x1, GRB.MAXIMIZE)

# Add constraints
model.addConstr(26*x0 + 3*x1 >= 47, "umami_index_lower")
model.addConstr(25*x0 + 16*x1 >= 66, "iron_milligrams_lower")
model.addConstr(x0 - 7*x1 >= 0, "protein_bars_ham_sandwiches")
model.addConstr(26*x0 + 3*x1 <= 72, "umami_index_upper")
model.addConstr(25*x0 + 16*x1 <= 121, "iron_milligrams_upper")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Protein bars: {x0.x}")
    print(f"Ham sandwiches: {x1.x}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found")
