
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="protein_bars", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="ham_sandwiches", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5.24 * x1 + 6.19 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(26 * x1 + 3 * x2 >= 47, name="umami_index_min")
    model.addConstr(25 * x1 + 16 * x2 >= 66, name="iron_min")
    model.addConstr(x1 - 7 * x2 >= 0, name="protein_bars_vs_ham_sandwiches")
    model.addConstr(26 * x1 + 3 * x2 <= 72, name="umami_index_max")
    model.addConstr(25 * x1 + 16 * x2 <= 121, name="iron_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Protein bars: {x1.varValue}")
        print(f"Ham sandwiches: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
