
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Work_Optimization")

    # Create variables
    bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill")
    jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Jean")
    bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")
    dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
    paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")


    # Set objective function
    model.setObjective(6.33 * bill + 3.95 * jean + 9.72 * bobby + 4.71 * dale + 1.45 * paul, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * jean + 7 * bobby >= 56)
    model.addConstr(12 * bill + 7 * bobby >= 20)
    model.addConstr(4 * jean + 10 * paul >= 22)
    model.addConstr(12 * bill + 4 * jean >= 50)
    model.addConstr(12 * bill + 8 * dale >= 52)
    model.addConstr(12 * bill + 8 * dale + 10 * paul >= 42)
    model.addConstr(4 * jean + 8 * dale + 10 * paul >= 42)
    model.addConstr(12 * bill + 8 * dale + 10 * paul >= 54)
    model.addConstr(4 * jean + 8 * dale + 10 * paul >= 54)
    model.addConstr(12 * bill + 8 * dale <= 217)
    model.addConstr(12 * bill + 4 * jean + 8 * dale <= 93)
    model.addConstr(4 * jean + 8 * dale + 10 * paul <= 258)
    model.addConstr(12 * bill + 7 * bobby + 8 * dale <= 236)
    model.addConstr(12 * bill + 4 * jean + 7 * bobby <= 74)
    model.addConstr(12 * bill + 7 * bobby + 10 * paul <= 212)
    model.addConstr(12 * bill + 4 * jean + 10 * paul <= 127)
    model.addConstr(7 * bobby + 8 * dale + 10 * paul <= 95)
    model.addConstr(12 * bill + 4 * jean + 7 * bobby + 8 * dale + 10 * paul <= 95)
    model.addConstr(12 * bill + 4 * jean + 7 * bobby + 8 * dale + 10 * paul <= 296)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
