
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Bill", lb=0)
    x2 = model.addVar(name="hours_worked_by_Jean", lb=0)
    x3 = model.addVar(name="hours_worked_by_Bobby", lb=0)
    x4 = model.addVar(name="hours_worked_by_Dale", lb=0)
    x5 = model.addVar(name="hours_worked_by_Paul", lb=0)

    # Objective function
    model.setObjective(6.33*x1 + 3.95*x2 + 9.72*x3 + 4.71*x4 + 1.45*x5, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x2 + 7*x3 >= 56)
    model.addConstr(12*x1 + 7*x3 >= 20)
    model.addConstr(4*x2 + 10*x5 >= 22)
    model.addConstr(12*x1 + 4*x2 >= 50)
    model.addConstr(12*x1 + 8*x4 >= 52)
    model.addConstr(12*x1 + 8*x4 + 10*x5 >= 42)
    model.addConstr(4*x2 + 8*x4 + 10*x5 >= 42)
    model.addConstr(12*x1 + 8*x4 + 10*x5 >= 54)
    model.addConstr(4*x2 + 8*x4 + 10*x5 >= 54)
    model.addConstr(12*x1 + 8*x4 <= 217)
    model.addConstr(12*x1 + 4*x2 + 8*x4 <= 93)
    model.addConstr(4*x2 + 8*x4 + 10*x5 <= 258)
    model.addConstr(12*x1 + 7*x3 + 8*x4 <= 236)
    model.addConstr(12*x1 + 4*x2 + 7*x3 <= 74)
    model.addConstr(12*x1 + 7*x3 + 10*x5 <= 212)
    model.addConstr(12*x1 + 4*x2 + 10*x5 <= 127)
    model.addConstr(7*x3 + 8*x4 + 10*x5 <= 95)
    model.addConstr(12*x1 + 4*x2 + 7*x3 + 8*x4 + 10*x5 <= 95)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Bill: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
        print("Hours worked by Bobby: ", x3.varValue)
        print("Hours worked by Dale: ", x4.varValue)
        print("Hours worked by Paul: ", x5.varValue)
    else:
        print("No optimal solution found")

optimize_problem()
