
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    cantaloupes = m.addVar(vtype=gp.GRB.INTEGER, name="cantaloupes")
    chicken_drumsticks = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_drumsticks")
    apple_pies = m.addVar(vtype=gp.GRB.INTEGER, name="apple_pies")
    bowls_of_pasta = m.addVar(vtype=gp.GRB.INTEGER, name="bowls_of_pasta")

    # Set objective function
    m.setObjective(3.28*cantaloupes**2 + 6.66*cantaloupes*apple_pies + 1.42*cantaloupes*bowls_of_pasta + 6.84*chicken_drumsticks**2 + 9.64*chicken_drumsticks*bowls_of_pasta + 3.22*apple_pies**2 + 4.23*apple_pies*bowls_of_pasta + 2.46*chicken_drumsticks, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*cantaloupes + 15*chicken_drumsticks + 18*apple_pies + 21*bowls_of_pasta <= 263, "calcium_upper_bound")
    m.addConstr(6*cantaloupes**2 + 21*bowls_of_pasta**2 >= 44, "calcium_constraint1")
    m.addConstr(18*apple_pies**2 + 21*bowls_of_pasta**2 >= 64, "calcium_constraint2")
    m.addConstr(15*chicken_drumsticks + 18*apple_pies + 21*bowls_of_pasta >= 35, "calcium_constraint3")
    m.addConstr(6*cantaloupes + 15*chicken_drumsticks + 21*bowls_of_pasta >= 35, "calcium_constraint4")
    m.addConstr(15*chicken_drumsticks + 18*apple_pies + 21*bowls_of_pasta >= 61, "calcium_constraint5")
    m.addConstr(6*cantaloupes + 15*chicken_drumsticks + 21*bowls_of_pasta >= 61, "calcium_constraint6")
    m.addConstr(6*cantaloupes + 15*chicken_drumsticks + 18*apple_pies + 21*bowls_of_pasta >= 61, "calcium_constraint7")
    m.addConstr(-3*apple_pies**2 + 2*bowls_of_pasta**2 >= 0, "constraint8")
    m.addConstr(6*cantaloupes + 15*chicken_drumsticks <= 175, "constraint9")
    m.addConstr(6*cantaloupes**2 + 15*chicken_drumsticks**2 + 21*bowls_of_pasta**2 <= 215, "constraint10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
