
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="cantaloupes", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="chicken_drumsticks", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="apple_pies", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="bowls_of_pasta", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3.28*x1**2 + 6.66*x1*x3 + 1.42*x1*x4 + 6.84*x2**2 + 9.64*x2*x4 + 3.22*x3**2 + 4.23*x3*x4 + 2.46*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6*x1 + 15*x2 + 18*x3 + 21*x4 <= 263)
    model.addConstr(x1**2 + x4**2 >= 44)
    model.addConstr(x3**2 + x4**2 >= 64)
    model.addConstr(15*x2 + 18*x3 + 21*x4 >= 35)
    model.addConstr(6*x1 + 15*x2 + 21*x4 >= 35)
    model.addConstr(15*x2 + 18*x3 + 21*x4 >= 61)
    model.addConstr(6*x1 + 15*x2 + 21*x4 >= 61)
    model.addConstr(6*x1 + 15*x2 + 18*x3 + 21*x4 >= 61)
    model.addConstr(-3*x3**2 + 2*x4**2 >= 0)
    model.addConstr(6*x1 + 15*x2 <= 175)
    model.addConstr(36*x1**2 + 225*x2**2 + 441*x4**2 <= 46225)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Cantaloupes: ", x1.varValue)
        print("Chicken drumsticks: ", x2.varValue)
        print("Apple pies: ", x3.varValue)
        print("Bowls of pasta: ", x4.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
