
import gurobipy as gp

# Create a new model
m = gp.Model("Employee_Scheduling")

# Create variables
laura = m.addVar(lb=0, name="Laura")
george = m.addVar(lb=0, name="George")
john = m.addVar(lb=0, name="John")
peggy = m.addVar(lb=0, name="Peggy")
mary = m.addVar(lb=0, name="Mary")


# Set objective function
m.setObjective(3 * laura + 4 * george + 7 * john + 6 * peggy + 7 * mary, gp.GRB.MAXIMIZE)

# Add constraints

m.addConstr(20 * john + 8 * peggy >= 34)
m.addConstr(9 * laura + 20 * john >= 57)
m.addConstr(9 * laura + 8 * peggy >= 65)
m.addConstr(20 * john + 15 * mary >= 32)
m.addConstr(9 * laura + 8 * peggy + 15 * mary >= 41)
m.addConstr(17 * laura + 13 * mary >= 30)
m.addConstr(11 * peggy + 13 * mary >= 68)
m.addConstr(11 * john + 11 * peggy >= 31)
m.addConstr(17 * laura + 3 * george >= 53)
m.addConstr(17 * laura + 11 * peggy >= 59)
m.addConstr(17 * laura + 11 * john >= 53)
m.addConstr(3 * george + 11 * john >= 35)
m.addConstr(5 * george + 1 * john >= 45)
m.addConstr(13 * laura + 1 * john >= 57)
m.addConstr(5 * george + 1 * peggy >= 27)
m.addConstr(13 * laura + 5 * george + 1 * john >= 49)
m.addConstr(13 * laura + 5 * george + 1 * peggy >= 49)
m.addConstr(5 * george + 1 * john + 16 * mary >= 49)
m.addConstr(13 * laura + 5 * george + 1 * john >= 52)
m.addConstr(13 * laura + 5 * george + 1 * peggy >= 52)
m.addConstr(5 * george + 1 * john + 16 * mary >= 52)
m.addConstr(13 * laura + 5 * george + 1 * john >= 50)
m.addConstr(13 * laura + 5 * george + 1 * peggy >= 50)
m.addConstr(5 * george + 1 * john + 16 * mary >= 50)
m.addConstr(14 * peggy + 8 * mary >= 31)
m.addConstr(2 * george + 8 * mary >= 37)
m.addConstr(19 * john + 14 * peggy >= 37)
m.addConstr(14 * laura + 2 * george >= 44)


# ... (rest of the constraints)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

