
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, vtype=GRB.INTEGER, name=["chili_plants", "potato_vines", "pansies", "basil_plants"])


    # Set objective function
    m.setObjective(6*x[0] + 3*x[1] + 6*x[2] + 5*x[3], GRB.MINIMIZE)

    # Add constraints
    m.addConstr(20*x[0] + 4*x[1] + 20*x[2] + 2*x[3] <= 195, "c0")
    m.addConstr(18*x[0] + 7*x[1] + 17*x[2] + 14*x[3] <= 298, "c1")
    m.addConstr(4*x[1] + 2*x[3] >= 37*144, "c2")
    m.addConstr(20*x[0] + 2*x[3] >= 17*144, "c3")
    m.addConstr(20*x[0] + 20*x[2] >= 43*144, "c4")
    m.addConstr(20*x[2] + 2*x[3] >= 16*144, "c5")
    m.addConstr(20*x[0] + 4*x[1] + 20*x[2] + 2*x[3] >= 16*144, "c6")
    m.addConstr(18*x[0] + 17*x[2] >= 65, "c7")
    m.addConstr(18*x[0] + 14*x[3] >= 63, "c8")
    m.addConstr(18*x[0] + 7*x[1] + 17*x[2] >= 53, "c9")
    m.addConstr(7*x[1] + 17*x[2] + 14*x[3] >= 53, "c10")
    m.addConstr(18*x[0] + 7*x[1] + 17*x[2] >= 61, "c11")
    m.addConstr(7*x[1] + 17*x[2] + 14*x[3] >= 61, "c12")
    m.addConstr(18*x[0] + 7*x[1] + 17*x[2] + 14*x[3] >= 61, "c13")
    m.addConstr(-10*x[0] + 9*x[1] >= 0, "c14")
    m.addConstr(3*x[1] - 10*x[2] >= 0, "c15")
    m.addConstr(7*x[1] + 14*x[3] <= 168, "c16")
    m.addConstr(17*x[2] + 14*x[3] <= 230, "c17")
    m.addConstr(18*x[0] + 17*x[2] + 14*x[3] <= 120, "c18")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
